<?php
/**
 * Admin Dashboard
 */
define('ECOMMERCE_ACCESS', true);
require_once '../config/db.php';
require_once '../config/auth.php';

requireAdmin();

$settings = getSettings();
$admin = getCurrentAdmin();

// Get statistics
$totalSales = fetchOne("SELECT COALESCE(SUM(total), 0) as total FROM orders WHERE payment_status = 'paid'")['total'];
$totalOrders = fetchOne("SELECT COUNT(*) as count FROM orders")['count'];
$totalUsers = fetchOne("SELECT COUNT(*) as count FROM users")['count'];
$totalProducts = fetchOne("SELECT COUNT(*) as count FROM products")['count'];
$pendingOrders = fetchOne("SELECT COUNT(*) as count FROM orders WHERE status = 'pending'")['count'];
$lowStock = fetchOne("SELECT COUNT(*) as count FROM products WHERE stock <= 5 AND status = 'active'")['count'];

// Recent orders
$recentOrders = fetchAll("
    SELECT o.*, u.name as user_name 
    FROM orders o 
    LEFT JOIN users u ON o.user_id = u.id 
    ORDER BY o.created_at DESC 
    LIMIT 5
");

// Top products
$topProducts = fetchAll("
    SELECT p.*, COALESCE(SUM(oi.quantity), 0) as sold 
    FROM products p 
    LEFT JOIN order_items oi ON p.id = oi.product_id 
    GROUP BY p.id 
    ORDER BY sold DESC 
    LIMIT 5
");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Admin Panel</title>
    <link rel="stylesheet" href="../assets/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #1e3a5f;
            --primary-light: #2d4a6f;
            --secondary: #f59e0b;
            --success: #10b981;
            --danger: #ef4444;
            --warning: #f59e0b;
            --info: #3b82f6;
            --gray-100: #f3f4f6;
            --gray-200: #e5e7eb;
            --gray-500: #6b7280;
            --gray-700: #374151;
            --gray-900: #111827;
        }
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body {
            font-family: 'Segoe UI', system-ui, sans-serif;
            background: var(--gray-100);
            color: var(--gray-700);
        }
        .admin-wrapper {
            display: flex;
            min-height: 100vh;
        }
        /* Sidebar */
        .sidebar {
            width: 260px;
            background: var(--primary);
            color: #fff;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
        }
        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar-header h2 {
            font-size: 20px;
            font-weight: 700;
        }
        .sidebar-header span {
            font-size: 12px;
            opacity: 0.7;
        }
        .sidebar-menu {
            padding: 20px 0;
        }
        .menu-item {
            display: flex;
            align-items: center;
            padding: 14px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            transition: all 0.3s;
            gap: 12px;
        }
        .menu-item:hover, .menu-item.active {
            background: rgba(255,255,255,0.1);
            color: #fff;
        }
        .menu-item i {
            width: 20px;
            text-align: center;
        }
        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: 260px;
            padding: 30px;
        }
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        .page-header h1 {
            font-size: 28px;
            color: var(--gray-900);
        }
        .admin-info {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .admin-info img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
        }
        /* Stats Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 24px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: #fff;
            border-radius: 12px;
            padding: 24px;
            display: flex;
            align-items: center;
            gap: 20px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.04);
        }
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        .stat-icon.sales { background: rgba(16, 185, 129, 0.1); color: var(--success); }
        .stat-icon.orders { background: rgba(59, 130, 246, 0.1); color: var(--info); }
        .stat-icon.users { background: rgba(245, 158, 11, 0.1); color: var(--warning); }
        .stat-icon.products { background: rgba(139, 92, 246, 0.1); color: #8b5cf6; }
        .stat-info h3 {
            font-size: 28px;
            color: var(--gray-900);
            margin-bottom: 4px;
        }
        .stat-info span {
            color: var(--gray-500);
            font-size: 14px;
        }
        /* Cards */
        .card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.04);
            margin-bottom: 24px;
        }
        .card-header {
            padding: 20px 24px;
            border-bottom: 1px solid var(--gray-200);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .card-header h3 {
            font-size: 18px;
            color: var(--gray-900);
        }
        .card-body {
            padding: 24px;
        }
        /* Table */
        .table {
            width: 100%;
            border-collapse: collapse;
        }
        .table th, .table td {
            padding: 14px 16px;
            text-align: left;
            border-bottom: 1px solid var(--gray-200);
        }
        .table th {
            font-weight: 600;
            color: var(--gray-500);
            font-size: 13px;
            text-transform: uppercase;
        }
        .table tr:last-child td {
            border-bottom: none;
        }
        /* Status badges */
        .badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .badge-pending { background: #fef3c7; color: #d97706; }
        .badge-paid { background: #d1fae5; color: #059669; }
        .badge-processing { background: #dbeafe; color: #2563eb; }
        .badge-shipped { background: #e0e7ff; color: #4f46e5; }
        .badge-delivered { background: #d1fae5; color: #059669; }
        .badge-cancelled { background: #fee2e2; color: #dc2626; }
        /* Alerts */
        .alert-box {
            display: flex;
            gap: 16px;
            margin-bottom: 24px;
        }
        .alert {
            flex: 1;
            padding: 16px 20px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .alert-warning {
            background: #fef3c7;
            color: #d97706;
        }
        .alert-info {
            background: #dbeafe;
            color: #2563eb;
        }
        .view-all {
            color: var(--primary);
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
        }
        .view-all:hover {
            text-decoration: underline;
        }
        /* Grid layout */
        .grid-2 {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 24px;
        }
        @media (max-width: 1024px) {
            .grid-2 { grid-template-columns: 1fr; }
        }
        @media (max-width: 768px) {
            .sidebar {
                width: 100%;
                height: auto;
                position: relative;
            }
            .main-content {
                margin-left: 0;
            }
            .admin-wrapper {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="admin-wrapper">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <h2><?php echo htmlspecialchars($settings['site_name']); ?></h2>
                <span>Admin Panel</span>
            </div>
            <nav class="sidebar-menu">
                <a href="dashboard.php" class="menu-item active">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
                <a href="products.php" class="menu-item">
                    <i class="fas fa-box"></i> Products
                </a>
                <a href="categories.php" class="menu-item">
                    <i class="fas fa-tags"></i> Categories
                </a>
                <a href="orders.php" class="menu-item">
                    <i class="fas fa-shopping-cart"></i> Orders
                </a>
                <a href="users.php" class="menu-item">
                    <i class="fas fa-users"></i> Users
                </a>
                <a href="settings.php" class="menu-item">
                    <i class="fas fa-cog"></i> Settings
                </a>
                <a href="logout.php" class="menu-item">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <div class="page-header">
                <h1>Dashboard</h1>
                <div class="admin-info">
                    <span>Welcome, <?php echo htmlspecialchars($admin['name']); ?></span>
                </div>
            </div>

            <!-- Alert boxes -->
            <?php if ($pendingOrders > 0 || $lowStock > 0): ?>
            <div class="alert-box">
                <?php if ($pendingOrders > 0): ?>
                <div class="alert alert-warning">
                    <i class="fas fa-clock"></i>
                    <span><strong><?php echo $pendingOrders; ?></strong> pending orders require attention</span>
                </div>
                <?php endif; ?>
                <?php if ($lowStock > 0): ?>
                <div class="alert alert-info">
                    <i class="fas fa-exclamation-triangle"></i>
                    <span><strong><?php echo $lowStock; ?></strong> products are low on stock</span>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <!-- Stats -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon sales">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo formatPrice($totalSales); ?></h3>
                        <span>Total Sales</span>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon orders">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo number_format($totalOrders); ?></h3>
                        <span>Total Orders</span>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon users">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo number_format($totalUsers); ?></h3>
                        <span>Registered Users</span>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon products">
                        <i class="fas fa-box"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo number_format($totalProducts); ?></h3>
                        <span>Products</span>
                    </div>
                </div>
            </div>

            <!-- Recent Orders & Top Products -->
            <div class="grid-2">
                <div class="card">
                    <div class="card-header">
                        <h3>Recent Orders</h3>
                        <a href="orders.php" class="view-all">View All</a>
                    </div>
                    <div class="card-body">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Order ID</th>
                                    <th>Customer</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($recentOrders)): ?>
                                <tr>
                                    <td colspan="4" style="text-align: center; color: var(--gray-500);">No orders yet</td>
                                </tr>
                                <?php else: ?>
                                <?php foreach ($recentOrders as $order): ?>
                                <tr>
                                    <td><a href="order-view.php?id=<?php echo $order['id']; ?>">#<?php echo htmlspecialchars($order['order_number']); ?></a></td>
                                    <td><?php echo htmlspecialchars($order['user_name'] ?? $order['shipping_name']); ?></td>
                                    <td><?php echo formatPrice($order['total']); ?></td>
                                    <td><span class="badge badge-<?php echo $order['status']; ?>"><?php echo ucfirst($order['status']); ?></span></td>
                                </tr>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3>Top Products</h3>
                        <a href="products.php" class="view-all">View All</a>
                    </div>
                    <div class="card-body">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Price</th>
                                    <th>Sold</th>
                                    <th>Stock</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($topProducts)): ?>
                                <tr>
                                    <td colspan="4" style="text-align: center; color: var(--gray-500);">No products yet</td>
                                </tr>
                                <?php else: ?>
                                <?php foreach ($topProducts as $product): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($product['name']); ?></td>
                                    <td><?php echo formatPrice($product['sale_price'] ?? $product['price']); ?></td>
                                    <td><?php echo number_format($product['sold']); ?></td>
                                    <td>
                                        <?php if ($product['stock'] <= 5): ?>
                                        <span style="color: var(--danger);"><?php echo $product['stock']; ?></span>
                                        <?php else: ?>
                                        <?php echo $product['stock']; ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
