<?php
/**
 * Admin Orders Management
 */
define('ECOMMERCE_ACCESS', true);
require_once '../config/db.php';
require_once '../config/auth.php';

requireAdmin();

$settings = getSettings();

// Pagination
$page = max(1, intval($_GET['page'] ?? 1));
$limit = 15;
$offset = ($page - 1) * $limit;

// Filters
$status = sanitize($_GET['status'] ?? '');
$search = sanitize($_GET['search'] ?? '');

$where = "1=1";
$params = [];

if ($status) {
    $where .= " AND o.status = ?";
    $params[] = $status;
}
if ($search) {
    $where .= " AND (o.order_number LIKE ? OR o.shipping_name LIKE ? OR o.shipping_email LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

// Get total count
$totalCount = fetchOne("SELECT COUNT(*) as count FROM orders o WHERE $where", $params)['count'];
$totalPages = ceil($totalCount / $limit);

// Get orders
$orders = fetchAll("
    SELECT o.*, u.name as user_name, u.email as user_email,
           (SELECT COUNT(*) FROM order_items WHERE order_id = o.id) as item_count
    FROM orders o 
    LEFT JOIN users u ON o.user_id = u.id 
    WHERE $where 
    ORDER BY o.created_at DESC 
    LIMIT $limit OFFSET $offset
", $params);

// Status counts
$statusCounts = fetchAll("
    SELECT status, COUNT(*) as count 
    FROM orders 
    GROUP BY status
");
$counts = [];
foreach ($statusCounts as $sc) {
    $counts[$sc['status']] = $sc['count'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Orders - Admin Panel</title>
    <link rel="stylesheet" href="../assets/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #1e3a5f; --primary-light: #2d4a6f; --success: #10b981; --danger: #ef4444; --warning: #f59e0b; --info: #3b82f6; --gray-100: #f3f4f6; --gray-200: #e5e7eb; --gray-500: #6b7280; --gray-700: #374151; --gray-900: #111827; }
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', system-ui, sans-serif; background: var(--gray-100); color: var(--gray-700); }
        .admin-wrapper { display: flex; min-height: 100vh; }
        .sidebar { width: 260px; background: var(--primary); color: #fff; position: fixed; height: 100vh; overflow-y: auto; }
        .sidebar-header { padding: 20px; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .sidebar-header h2 { font-size: 20px; font-weight: 700; }
        .sidebar-header span { font-size: 12px; opacity: 0.7; }
        .sidebar-menu { padding: 20px 0; }
        .menu-item { display: flex; align-items: center; padding: 14px 20px; color: rgba(255,255,255,0.8); text-decoration: none; transition: all 0.3s; gap: 12px; }
        .menu-item:hover, .menu-item.active { background: rgba(255,255,255,0.1); color: #fff; }
        .menu-item i { width: 20px; text-align: center; }
        .main-content { flex: 1; margin-left: 260px; padding: 30px; }
        .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; }
        .page-header h1 { font-size: 28px; color: var(--gray-900); }
        .btn { padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: 500; cursor: pointer; border: none; transition: all 0.3s; display: inline-flex; align-items: center; gap: 8px; }
        .btn-primary { background: var(--primary); color: #fff; }
        .btn-sm { padding: 6px 12px; font-size: 13px; }
        .card { background: #fff; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.04); margin-bottom: 24px; }
        .card-body { padding: 24px; }
        .status-tabs { display: flex; gap: 8px; margin-bottom: 24px; flex-wrap: wrap; }
        .status-tab { padding: 10px 16px; border-radius: 8px; text-decoration: none; color: var(--gray-700); background: #fff; border: 1px solid var(--gray-200); font-size: 14px; }
        .status-tab:hover, .status-tab.active { background: var(--primary); color: #fff; border-color: var(--primary); }
        .status-tab .count { background: var(--gray-200); color: var(--gray-700); padding: 2px 8px; border-radius: 10px; font-size: 12px; margin-left: 6px; }
        .status-tab.active .count { background: rgba(255,255,255,0.3); color: #fff; }
        .filters { display: flex; gap: 16px; margin-bottom: 24px; }
        .filters input { padding: 10px 14px; border: 1px solid var(--gray-200); border-radius: 8px; min-width: 300px; }
        .table { width: 100%; border-collapse: collapse; }
        .table th, .table td { padding: 14px 16px; text-align: left; border-bottom: 1px solid var(--gray-200); }
        .table th { font-weight: 600; color: var(--gray-500); font-size: 13px; text-transform: uppercase; background: var(--gray-100); }
        .badge { padding: 4px 10px; border-radius: 20px; font-size: 12px; font-weight: 600; }
        .badge-pending { background: #fef3c7; color: #d97706; }
        .badge-paid { background: #d1fae5; color: #059669; }
        .badge-processing { background: #dbeafe; color: #2563eb; }
        .badge-shipped { background: #e0e7ff; color: #4f46e5; }
        .badge-delivered { background: #d1fae5; color: #059669; }
        .badge-cancelled { background: #fee2e2; color: #dc2626; }
        .badge-refunded { background: #fce7f3; color: #db2777; }
        .pagination { display: flex; justify-content: center; gap: 8px; margin-top: 24px; }
        .pagination a, .pagination span { padding: 8px 14px; border-radius: 6px; text-decoration: none; color: var(--gray-700); background: #fff; border: 1px solid var(--gray-200); }
        .pagination a:hover { background: var(--primary); color: #fff; }
        .pagination .active { background: var(--primary); color: #fff; }
        @media (max-width: 768px) {
            .sidebar { width: 100%; height: auto; position: relative; }
            .main-content { margin-left: 0; }
            .admin-wrapper { flex-direction: column; }
            .filters input { min-width: 100%; }
        }
    </style>
</head>
<body>
    <div class="admin-wrapper">
        <aside class="sidebar">
            <div class="sidebar-header">
                <h2><?php echo htmlspecialchars($settings['site_name']); ?></h2>
                <span>Admin Panel</span>
            </div>
            <nav class="sidebar-menu">
                <a href="dashboard.php" class="menu-item"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
                <a href="products.php" class="menu-item"><i class="fas fa-box"></i> Products</a>
                <a href="categories.php" class="menu-item"><i class="fas fa-tags"></i> Categories</a>
                <a href="orders.php" class="menu-item active"><i class="fas fa-shopping-cart"></i> Orders</a>
                <a href="users.php" class="menu-item"><i class="fas fa-users"></i> Users</a>
                <a href="settings.php" class="menu-item"><i class="fas fa-cog"></i> Settings</a>
                <a href="logout.php" class="menu-item"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </nav>
        </aside>

        <main class="main-content">
            <div class="page-header">
                <h1>Orders</h1>
            </div>

            <?php echo displayFlash(); ?>

            <!-- Status Tabs -->
            <div class="status-tabs">
                <a href="orders.php" class="status-tab <?php echo !$status ? 'active' : ''; ?>">
                    All <span class="count"><?php echo $totalCount; ?></span>
                </a>
                <a href="orders.php?status=pending" class="status-tab <?php echo $status === 'pending' ? 'active' : ''; ?>">
                    Pending <span class="count"><?php echo $counts['pending'] ?? 0; ?></span>
                </a>
                <a href="orders.php?status=paid" class="status-tab <?php echo $status === 'paid' ? 'active' : ''; ?>">
                    Paid <span class="count"><?php echo $counts['paid'] ?? 0; ?></span>
                </a>
                <a href="orders.php?status=processing" class="status-tab <?php echo $status === 'processing' ? 'active' : ''; ?>">
                    Processing <span class="count"><?php echo $counts['processing'] ?? 0; ?></span>
                </a>
                <a href="orders.php?status=shipped" class="status-tab <?php echo $status === 'shipped' ? 'active' : ''; ?>">
                    Shipped <span class="count"><?php echo $counts['shipped'] ?? 0; ?></span>
                </a>
                <a href="orders.php?status=delivered" class="status-tab <?php echo $status === 'delivered' ? 'active' : ''; ?>">
                    Delivered <span class="count"><?php echo $counts['delivered'] ?? 0; ?></span>
                </a>
                <a href="orders.php?status=cancelled" class="status-tab <?php echo $status === 'cancelled' ? 'active' : ''; ?>">
                    Cancelled <span class="count"><?php echo $counts['cancelled'] ?? 0; ?></span>
                </a>
            </div>

            <!-- Search -->
            <div class="card">
                <div class="card-body">
                    <form method="GET" class="filters">
                        <?php if ($status): ?>
                        <input type="hidden" name="status" value="<?php echo htmlspecialchars($status); ?>">
                        <?php endif; ?>
                        <input type="text" name="search" placeholder="Search by order number, name, or email..." 
                               value="<?php echo htmlspecialchars($search); ?>">
                        <button type="submit" class="btn btn-primary btn-sm">Search</button>
                    </form>
                </div>
            </div>

            <!-- Orders Table -->
            <div class="card">
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Order</th>
                                <th>Customer</th>
                                <th>Items</th>
                                <th>Total</th>
                                <th>Payment</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($orders)): ?>
                            <tr>
                                <td colspan="8" style="text-align: center; padding: 40px; color: var(--gray-500);">
                                    No orders found
                                </td>
                            </tr>
                            <?php else: ?>
                            <?php foreach ($orders as $order): ?>
                            <tr>
                                <td>
                                    <a href="order-view.php?id=<?php echo $order['id']; ?>" style="color: var(--primary); font-weight: 600;">
                                        #<?php echo htmlspecialchars($order['order_number']); ?>
                                    </a>
                                </td>
                                <td>
                                    <?php echo htmlspecialchars($order['shipping_name']); ?>
                                    <br><small style="color: var(--gray-500);"><?php echo htmlspecialchars($order['shipping_email']); ?></small>
                                </td>
                                <td><?php echo $order['item_count']; ?> items</td>
                                <td><strong><?php echo formatPrice($order['total']); ?></strong></td>
                                <td>
                                    <span class="badge badge-<?php echo $order['payment_status']; ?>">
                                        <?php echo ucfirst($order['payment_status']); ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="badge badge-<?php echo $order['status']; ?>">
                                        <?php echo ucfirst($order['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('M d, Y', strtotime($order['created_at'])); ?></td>
                                <td>
                                    <a href="order-view.php?id=<?php echo $order['id']; ?>" class="btn btn-primary btn-sm">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>

                    <?php if ($totalPages > 1): ?>
                    <div class="pagination">
                        <?php if ($page > 1): ?>
                        <a href="?page=<?php echo $page - 1; ?>&status=<?php echo urlencode($status); ?>&search=<?php echo urlencode($search); ?>">&laquo; Prev</a>
                        <?php endif; ?>
                        
                        <?php for ($i = max(1, $page - 2); $i <= min($totalPages, $page + 2); $i++): ?>
                        <?php if ($i == $page): ?>
                        <span class="active"><?php echo $i; ?></span>
                        <?php else: ?>
                        <a href="?page=<?php echo $i; ?>&status=<?php echo urlencode($status); ?>&search=<?php echo urlencode($search); ?>"><?php echo $i; ?></a>
                        <?php endif; ?>
                        <?php endfor; ?>
                        
                        <?php if ($page < $totalPages): ?>
                        <a href="?page=<?php echo $page + 1; ?>&status=<?php echo urlencode($status); ?>&search=<?php echo urlencode($search); ?>">Next &raquo;</a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
