<?php
/**
 * Admin Settings
 */
define('ECOMMERCE_ACCESS', true);
require_once '../config/db.php';
require_once '../config/auth.php';

requireAdmin();

$settings = getSettings();
$errors = [];
$success = false;

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid request';
    } else {
        $tab = $_POST['tab'] ?? 'general';
        
        if ($tab === 'general') {
            $siteName = sanitize($_POST['site_name'] ?? '');
            $siteEmail = sanitize($_POST['site_email'] ?? '');
            $sitePhone = sanitize($_POST['site_phone'] ?? '');
            $siteAddress = sanitize($_POST['site_address'] ?? '');
            $currency = sanitize($_POST['currency'] ?? 'BDT');
            $currencySymbol = sanitize($_POST['currency_symbol'] ?? '৳');
            
            // Handle logo upload
            $logo = $settings['site_logo'];
            if (isset($_FILES['site_logo']) && $_FILES['site_logo']['error'] === UPLOAD_ERR_OK) {
                $uploadDir = '../uploads/';
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0755, true);
                }
                
                $allowedTypes = ['image/jpeg', 'image/png', 'image/webp', 'image/gif'];
                if (in_array($_FILES['site_logo']['type'], $allowedTypes)) {
                    $ext = pathinfo($_FILES['site_logo']['name'], PATHINFO_EXTENSION);
                    $newLogo = 'logo_' . time() . '.' . $ext;
                    
                    if (move_uploaded_file($_FILES['site_logo']['tmp_name'], $uploadDir . $newLogo)) {
                        // Delete old logo
                        if ($logo && file_exists($uploadDir . $logo)) {
                            unlink($uploadDir . $logo);
                        }
                        $logo = $newLogo;
                    }
                }
            }
            
            query(
                "UPDATE settings SET site_name = ?, site_email = ?, site_phone = ?, site_address = ?, 
                 currency = ?, currency_symbol = ?, site_logo = ? WHERE id = 1",
                [$siteName, $siteEmail, $sitePhone, $siteAddress, $currency, $currencySymbol, $logo]
            );
            
            setFlash('success', 'General settings updated');
        }
        
        if ($tab === 'payment') {
            $sslStoreId = sanitize($_POST['ssl_store_id'] ?? '');
            $sslStorePassword = sanitize($_POST['ssl_store_password'] ?? '');
            $sslSandbox = isset($_POST['ssl_sandbox']) ? 1 : 0;
            
            $bkashAppKey = sanitize($_POST['bkash_app_key'] ?? '');
            $bkashAppSecret = sanitize($_POST['bkash_app_secret'] ?? '');
            $bkashUsername = sanitize($_POST['bkash_username'] ?? '');
            $bkashPassword = sanitize($_POST['bkash_password'] ?? '');
            $bkashSandbox = isset($_POST['bkash_sandbox']) ? 1 : 0;
            
            query(
                "UPDATE settings SET ssl_store_id = ?, ssl_store_password = ?, ssl_sandbox = ?,
                 bkash_app_key = ?, bkash_app_secret = ?, bkash_username = ?, bkash_password = ?, bkash_sandbox = ?
                 WHERE id = 1",
                [$sslStoreId, $sslStorePassword, $sslSandbox, $bkashAppKey, $bkashAppSecret, $bkashUsername, $bkashPassword, $bkashSandbox]
            );
            
            setFlash('success', 'Payment settings updated');
        }
        
        header('Location: settings.php?tab=' . $tab);
        exit;
    }
}

// Refresh settings after update
$settings = getSettings();
$activeTab = $_GET['tab'] ?? 'general';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - Admin Panel</title>
    <link rel="stylesheet" href="../assets/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #1e3a5f; --primary-light: #2d4a6f; --success: #10b981; --danger: #ef4444; --gray-100: #f3f4f6; --gray-200: #e5e7eb; --gray-500: #6b7280; --gray-700: #374151; --gray-900: #111827; }
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', system-ui, sans-serif; background: var(--gray-100); color: var(--gray-700); }
        .admin-wrapper { display: flex; min-height: 100vh; }
        .sidebar { width: 260px; background: var(--primary); color: #fff; position: fixed; height: 100vh; overflow-y: auto; }
        .sidebar-header { padding: 20px; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .sidebar-header h2 { font-size: 20px; font-weight: 700; }
        .sidebar-header span { font-size: 12px; opacity: 0.7; }
        .sidebar-menu { padding: 20px 0; }
        .menu-item { display: flex; align-items: center; padding: 14px 20px; color: rgba(255,255,255,0.8); text-decoration: none; transition: all 0.3s; gap: 12px; }
        .menu-item:hover, .menu-item.active { background: rgba(255,255,255,0.1); color: #fff; }
        .menu-item i { width: 20px; text-align: center; }
        .main-content { flex: 1; margin-left: 260px; padding: 30px; }
        .page-header { margin-bottom: 30px; }
        .page-header h1 { font-size: 28px; color: var(--gray-900); }
        .btn { padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: 500; cursor: pointer; border: none; transition: all 0.3s; display: inline-flex; align-items: center; gap: 8px; }
        .btn-primary { background: var(--primary); color: #fff; }
        .btn-primary:hover { background: var(--primary-light); }
        .card { background: #fff; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.04); margin-bottom: 24px; }
        .card-header { padding: 20px 24px; border-bottom: 1px solid var(--gray-200); }
        .card-header h3 { font-size: 18px; color: var(--gray-900); }
        .card-body { padding: 24px; }
        .tabs { display: flex; gap: 8px; margin-bottom: 24px; }
        .tab { padding: 12px 20px; border-radius: 8px; text-decoration: none; color: var(--gray-700); background: #fff; border: 1px solid var(--gray-200); }
        .tab:hover, .tab.active { background: var(--primary); color: #fff; border-color: var(--primary); }
        .form-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 24px; }
        .form-group { margin-bottom: 20px; }
        .form-group.full { grid-column: span 2; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 500; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 12px 16px; border: 1px solid var(--gray-200); border-radius: 8px; font-size: 14px; }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus { outline: none; border-color: var(--primary); }
        .form-group small { color: var(--gray-500); font-size: 12px; margin-top: 4px; display: block; }
        .checkbox-group { display: flex; align-items: center; gap: 10px; }
        .checkbox-group input { width: auto; }
        .current-logo { margin-bottom: 12px; }
        .current-logo img { max-height: 60px; }
        .alert { padding: 14px 20px; border-radius: 8px; margin-bottom: 24px; }
        .alert-success { background: #d1fae5; color: #059669; }
        .alert-warning { background: #fef3c7; color: #d97706; }
        .section-title { font-size: 16px; font-weight: 600; color: var(--gray-900); margin-bottom: 16px; padding-bottom: 12px; border-bottom: 1px solid var(--gray-200); }
        @media (max-width: 768px) {
            .sidebar { width: 100%; height: auto; position: relative; }
            .main-content { margin-left: 0; }
            .admin-wrapper { flex-direction: column; }
            .form-grid { grid-template-columns: 1fr; }
            .form-group.full { grid-column: span 1; }
        }
    </style>
</head>
<body>
    <div class="admin-wrapper">
        <aside class="sidebar">
            <div class="sidebar-header">
                <h2><?php echo htmlspecialchars($settings['site_name']); ?></h2>
                <span>Admin Panel</span>
            </div>
            <nav class="sidebar-menu">
                <a href="dashboard.php" class="menu-item"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
                <a href="products.php" class="menu-item"><i class="fas fa-box"></i> Products</a>
                <a href="categories.php" class="menu-item"><i class="fas fa-tags"></i> Categories</a>
                <a href="orders.php" class="menu-item"><i class="fas fa-shopping-cart"></i> Orders</a>
                <a href="users.php" class="menu-item"><i class="fas fa-users"></i> Users</a>
                <a href="settings.php" class="menu-item active"><i class="fas fa-cog"></i> Settings</a>
                <a href="logout.php" class="menu-item"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </nav>
        </aside>

        <main class="main-content">
            <div class="page-header">
                <h1>Settings</h1>
            </div>

            <?php echo displayFlash(); ?>

            <div class="tabs">
                <a href="settings.php?tab=general" class="tab <?php echo $activeTab === 'general' ? 'active' : ''; ?>">
                    <i class="fas fa-cog"></i> General
                </a>
                <a href="settings.php?tab=payment" class="tab <?php echo $activeTab === 'payment' ? 'active' : ''; ?>">
                    <i class="fas fa-credit-card"></i> Payment Gateway
                </a>
            </div>

            <?php if ($activeTab === 'general'): ?>
            <!-- General Settings -->
            <form method="POST" enctype="multipart/form-data">
                <?php echo csrfField(); ?>
                <input type="hidden" name="tab" value="general">
                
                <div class="card">
                    <div class="card-header">
                        <h3>General Settings</h3>
                    </div>
                    <div class="card-body">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="site_name">Site Name</label>
                                <input type="text" id="site_name" name="site_name" 
                                       value="<?php echo htmlspecialchars($settings['site_name']); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="site_email">Contact Email</label>
                                <input type="email" id="site_email" name="site_email" 
                                       value="<?php echo htmlspecialchars($settings['site_email'] ?? ''); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="site_phone">Contact Phone</label>
                                <input type="text" id="site_phone" name="site_phone" 
                                       value="<?php echo htmlspecialchars($settings['site_phone'] ?? ''); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="currency">Currency</label>
                                <select id="currency" name="currency">
                                    <option value="BDT" <?php echo $settings['currency'] === 'BDT' ? 'selected' : ''; ?>>BDT - Bangladeshi Taka</option>
                                    <option value="USD" <?php echo $settings['currency'] === 'USD' ? 'selected' : ''; ?>>USD - US Dollar</option>
                                    <option value="EUR" <?php echo $settings['currency'] === 'EUR' ? 'selected' : ''; ?>>EUR - Euro</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="currency_symbol">Currency Symbol</label>
                                <input type="text" id="currency_symbol" name="currency_symbol" 
                                       value="<?php echo htmlspecialchars($settings['currency_symbol']); ?>">
                            </div>
                            
                            <div class="form-group full">
                                <label for="site_address">Business Address</label>
                                <textarea id="site_address" name="site_address" rows="2"><?php echo htmlspecialchars($settings['site_address'] ?? ''); ?></textarea>
                            </div>
                            
                            <div class="form-group full">
                                <label for="site_logo">Site Logo</label>
                                <?php if ($settings['site_logo']): ?>
                                <div class="current-logo">
                                    <img src="../uploads/<?php echo htmlspecialchars($settings['site_logo']); ?>" alt="Current Logo">
                                </div>
                                <?php endif; ?>
                                <input type="file" id="site_logo" name="site_logo" accept="image/*">
                                <small>Recommended: 200x60px. Max 1MB</small>
                            </div>
                        </div>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Save Settings</button>
            </form>
            <?php endif; ?>

            <?php if ($activeTab === 'payment'): ?>
            <!-- Payment Settings -->
            <form method="POST">
                <?php echo csrfField(); ?>
                <input type="hidden" name="tab" value="payment">
                
                <div class="card">
                    <div class="card-header">
                        <h3>SSLCommerz Settings</h3>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-warning">
                            <i class="fas fa-info-circle"></i> Get your credentials from <a href="https://developer.sslcommerz.com/" target="_blank">SSLCommerz Developer Panel</a>
                        </div>
                        
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="ssl_store_id">Store ID</label>
                                <input type="text" id="ssl_store_id" name="ssl_store_id" 
                                       value="<?php echo htmlspecialchars($settings['ssl_store_id'] ?? ''); ?>"
                                       placeholder="your_store_id">
                            </div>
                            
                            <div class="form-group">
                                <label for="ssl_store_password">Store Password</label>
                                <input type="password" id="ssl_store_password" name="ssl_store_password" 
                                       value="<?php echo htmlspecialchars($settings['ssl_store_password'] ?? ''); ?>"
                                       placeholder="your_store_password">
                            </div>
                            
                            <div class="form-group full">
                                <div class="checkbox-group">
                                    <input type="checkbox" id="ssl_sandbox" name="ssl_sandbox" value="1" 
                                           <?php echo ($settings['ssl_sandbox'] ?? 1) ? 'checked' : ''; ?>>
                                    <label for="ssl_sandbox" style="margin: 0;">Enable Sandbox Mode (for testing)</label>
                                </div>
                                <small>Uncheck this when going live with real payments</small>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3>bKash Settings (Optional)</h3>
                    </div>
                    <div class="card-body">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="bkash_app_key">App Key</label>
                                <input type="text" id="bkash_app_key" name="bkash_app_key" 
                                       value="<?php echo htmlspecialchars($settings['bkash_app_key'] ?? ''); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="bkash_app_secret">App Secret</label>
                                <input type="password" id="bkash_app_secret" name="bkash_app_secret" 
                                       value="<?php echo htmlspecialchars($settings['bkash_app_secret'] ?? ''); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="bkash_username">Username</label>
                                <input type="text" id="bkash_username" name="bkash_username" 
                                       value="<?php echo htmlspecialchars($settings['bkash_username'] ?? ''); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="bkash_password">Password</label>
                                <input type="password" id="bkash_password" name="bkash_password" 
                                       value="<?php echo htmlspecialchars($settings['bkash_password'] ?? ''); ?>">
                            </div>
                            
                            <div class="form-group full">
                                <div class="checkbox-group">
                                    <input type="checkbox" id="bkash_sandbox" name="bkash_sandbox" value="1" 
                                           <?php echo ($settings['bkash_sandbox'] ?? 1) ? 'checked' : ''; ?>>
                                    <label for="bkash_sandbox" style="margin: 0;">Enable Sandbox Mode</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Save Payment Settings</button>
            </form>
            <?php endif; ?>
        </main>
    </div>
</body>
</html>
