<?php
/**
 * User Dashboard
 */
define('ECOMMERCE_ACCESS', true);
require_once '../config/db.php';
require_once '../config/auth.php';

requireUser();

$settings = getSettings();
$user = getCurrentUser();

// Get stats
$totalOrders = fetchOne("SELECT COUNT(*) as count FROM orders WHERE user_id = ?", [$user['id']])['count'];
$totalSpent = fetchOne("SELECT COALESCE(SUM(total), 0) as total FROM orders WHERE user_id = ? AND payment_status = 'paid'", [$user['id']])['total'];
$pendingOrders = fetchOne("SELECT COUNT(*) as count FROM orders WHERE user_id = ? AND status IN ('pending', 'paid', 'processing')", [$user['id']])['count'];

// Recent orders
$recentOrders = fetchAll("
    SELECT * FROM orders 
    WHERE user_id = ? 
    ORDER BY created_at DESC 
    LIMIT 5
", [$user['id']]);

// Cart count
$cartCount = fetchOne("SELECT COUNT(*) as count FROM cart WHERE user_id = ?", [$user['id']])['count'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Dashboard - <?php echo htmlspecialchars($settings['site_name']); ?></title>
    <link rel="stylesheet" href="../assets/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #0ea5e9; --primary-dark: #0284c7; --success: #10b981; --warning: #f59e0b; --gray-100: #f1f5f9; --gray-200: #e2e8f0; --gray-500: #64748b; --gray-700: #334155; --gray-900: #0f172a; }
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', system-ui, sans-serif; background: var(--gray-100); color: var(--gray-700); }
        .header { background: #fff; padding: 16px 0; box-shadow: 0 1px 3px rgba(0,0,0,0.1); position: sticky; top: 0; z-index: 100; }
        .header-content { max-width: 1200px; margin: 0 auto; padding: 0 20px; display: flex; justify-content: space-between; align-items: center; }
        .logo { font-size: 24px; font-weight: 700; color: var(--primary); text-decoration: none; }
        .nav { display: flex; gap: 24px; align-items: center; }
        .nav a { color: var(--gray-700); text-decoration: none; font-weight: 500; transition: color 0.3s; }
        .nav a:hover { color: var(--primary); }
        .nav .cart-link { position: relative; }
        .cart-badge { position: absolute; top: -8px; right: -12px; background: var(--primary); color: #fff; font-size: 11px; padding: 2px 6px; border-radius: 10px; }
        .container { max-width: 1200px; margin: 0 auto; padding: 30px 20px; }
        .page-title { font-size: 28px; color: var(--gray-900); margin-bottom: 30px; }
        .stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 30px; }
        .stat-card { background: #fff; border-radius: 12px; padding: 24px; display: flex; align-items: center; gap: 16px; box-shadow: 0 1px 3px rgba(0,0,0,0.05); }
        .stat-icon { width: 50px; height: 50px; border-radius: 10px; display: flex; align-items: center; justify-content: center; font-size: 20px; }
        .stat-icon.orders { background: rgba(14, 165, 233, 0.1); color: var(--primary); }
        .stat-icon.spent { background: rgba(16, 185, 129, 0.1); color: var(--success); }
        .stat-icon.pending { background: rgba(245, 158, 11, 0.1); color: var(--warning); }
        .stat-info h3 { font-size: 24px; color: var(--gray-900); }
        .stat-info span { font-size: 14px; color: var(--gray-500); }
        .grid-2 { display: grid; grid-template-columns: 2fr 1fr; gap: 24px; }
        .card { background: #fff; border-radius: 12px; box-shadow: 0 1px 3px rgba(0,0,0,0.05); }
        .card-header { padding: 20px; border-bottom: 1px solid var(--gray-200); display: flex; justify-content: space-between; align-items: center; }
        .card-header h3 { font-size: 18px; color: var(--gray-900); }
        .card-header a { color: var(--primary); text-decoration: none; font-size: 14px; }
        .card-body { padding: 20px; }
        .order-item { display: flex; justify-content: space-between; align-items: center; padding: 14px 0; border-bottom: 1px solid var(--gray-100); }
        .order-item:last-child { border-bottom: none; }
        .order-info a { color: var(--primary); font-weight: 600; text-decoration: none; }
        .order-info span { display: block; font-size: 13px; color: var(--gray-500); margin-top: 4px; }
        .badge { padding: 4px 10px; border-radius: 20px; font-size: 12px; font-weight: 600; }
        .badge-pending { background: #fef3c7; color: #d97706; }
        .badge-paid { background: #d1fae5; color: #059669; }
        .badge-processing { background: #dbeafe; color: #2563eb; }
        .badge-shipped { background: #e0e7ff; color: #4f46e5; }
        .badge-delivered { background: #d1fae5; color: #059669; }
        .badge-cancelled { background: #fee2e2; color: #dc2626; }
        .quick-links { list-style: none; }
        .quick-links li { margin-bottom: 8px; }
        .quick-links a { display: flex; align-items: center; gap: 12px; padding: 14px 16px; background: var(--gray-100); border-radius: 8px; color: var(--gray-700); text-decoration: none; transition: all 0.3s; }
        .quick-links a:hover { background: var(--primary); color: #fff; }
        .quick-links a i { width: 20px; }
        .empty-state { text-align: center; padding: 40px 20px; color: var(--gray-500); }
        @media (max-width: 768px) {
            .grid-2 { grid-template-columns: 1fr; }
            .nav { gap: 16px; }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <a href="../index.php" class="logo"><?php echo htmlspecialchars($settings['site_name']); ?></a>
            <nav class="nav">
                <a href="products.php">Shop</a>
                <a href="cart.php" class="cart-link">
                    <i class="fas fa-shopping-cart"></i>
                    <?php if ($cartCount > 0): ?>
                    <span class="cart-badge"><?php echo $cartCount; ?></span>
                    <?php endif; ?>
                </a>
                <a href="dashboard.php">My Account</a>
                <a href="logout.php">Logout</a>
            </nav>
        </div>
    </header>

    <div class="container">
        <h1 class="page-title">Welcome, <?php echo htmlspecialchars($user['name']); ?>!</h1>
        
        <?php echo displayFlash(); ?>
        
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon orders"><i class="fas fa-shopping-bag"></i></div>
                <div class="stat-info">
                    <h3><?php echo number_format($totalOrders); ?></h3>
                    <span>Total Orders</span>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon spent"><i class="fas fa-wallet"></i></div>
                <div class="stat-info">
                    <h3><?php echo formatPrice($totalSpent); ?></h3>
                    <span>Total Spent</span>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon pending"><i class="fas fa-clock"></i></div>
                <div class="stat-info">
                    <h3><?php echo number_format($pendingOrders); ?></h3>
                    <span>Active Orders</span>
                </div>
            </div>
        </div>
        
        <div class="grid-2">
            <div class="card">
                <div class="card-header">
                    <h3>Recent Orders</h3>
                    <a href="orders.php">View All</a>
                </div>
                <div class="card-body">
                    <?php if (empty($recentOrders)): ?>
                    <div class="empty-state">
                        <i class="fas fa-shopping-bag" style="font-size: 48px; margin-bottom: 16px; opacity: 0.3;"></i>
                        <p>No orders yet. <a href="products.php">Start shopping!</a></p>
                    </div>
                    <?php else: ?>
                    <?php foreach ($recentOrders as $order): ?>
                    <div class="order-item">
                        <div class="order-info">
                            <a href="orders.php?view=<?php echo $order['id']; ?>">#<?php echo htmlspecialchars($order['order_number']); ?></a>
                            <span><?php echo date('M d, Y', strtotime($order['created_at'])); ?> &bull; <?php echo formatPrice($order['total']); ?></span>
                        </div>
                        <span class="badge badge-<?php echo $order['status']; ?>"><?php echo ucfirst($order['status']); ?></span>
                    </div>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h3>Quick Links</h3>
                </div>
                <div class="card-body">
                    <ul class="quick-links">
                        <li><a href="products.php"><i class="fas fa-store"></i> Browse Products</a></li>
                        <li><a href="cart.php"><i class="fas fa-shopping-cart"></i> View Cart</a></li>
                        <li><a href="orders.php"><i class="fas fa-box"></i> Order History</a></li>
                        <li><a href="profile.php"><i class="fas fa-user"></i> Edit Profile</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
